/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.entites;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class AnimatedGraveyardEntity
extends CreatureEntity
implements IAngerable {
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", (double)0.15f, AttributeModifier.Operation.ADDITION);
    private static final DataParameter<Boolean> DATA_CREEPY = EntityDataManager.func_187226_a(AnimatedGraveyardEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DATA_STARED_AT = EntityDataManager.func_187226_a(AnimatedGraveyardEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Byte> ANIMATION_MOVE_STATE = EntityDataManager.func_187226_a(AnimatedGraveyardEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private int lastStareSound = Integer.MIN_VALUE;
    private int targetChangeTime;
    private static final RangedInteger PERSISTENT_ANGER_TIME = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    protected AnimatedGraveyardEntity(EntityType<? extends CreatureEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANIMATION_MOVE_STATE, (Object)0);
        this.field_70180_af.func_187214_a(DATA_CREEPY, (Object)false);
        this.field_70180_af.func_187214_a(DATA_STARED_AT, (Object)false);
    }

    public int getAnimationState() {
        return ((Byte)this.field_70180_af.func_187225_a(ANIMATION_MOVE_STATE)).byteValue();
    }

    public void setState(byte time) {
        this.field_70180_af.func_187227_b(ANIMATION_MOVE_STATE, (Object)time);
    }

    public void func_230258_H__() {
        this.func_230260_a__(PERSISTENT_ANGER_TIME.func_233018_a_(this.field_70146_Z));
    }

    public void func_230260_a__(int p_230260_1_) {
        this.remainingPersistentAngerTime = p_230260_1_;
    }

    public int func_230256_F__() {
        return this.remainingPersistentAngerTime;
    }

    public void func_230259_a_(@Nullable UUID p_230259_1_) {
        this.persistentAngerTarget = p_230259_1_;
    }

    public UUID func_230257_G__() {
        return this.persistentAngerTarget;
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        this.func_233682_c_(p_213281_1_);
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        if (!this.field_70170_p.field_72995_K) {
            this.func_241358_a_((ServerWorld)this.field_70170_p, p_70037_1_);
        }
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_241359_a_((ServerWorld)this.field_70170_p, true);
        }
        super.func_70636_d();
    }

    public boolean isCreepy() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_CREEPY);
    }

    public boolean func_233678_J__() {
        return this.remainingPersistentAngerTime > 0;
    }

    public void func_70624_b(@Nullable LivingEntity p_70624_1_) {
        ModifiableAttributeInstance modifiableattributeinstance = this.func_110148_a(Attributes.field_233821_d_);
        if (p_70624_1_ == null) {
            this.targetChangeTime = 0;
            this.field_70180_af.func_187227_b(DATA_CREEPY, (Object)false);
            this.field_70180_af.func_187227_b(DATA_STARED_AT, (Object)false);
            modifiableattributeinstance.func_111124_b(SPEED_MODIFIER_ATTACKING);
        } else {
            this.targetChangeTime = this.field_70173_aa;
            this.field_70180_af.func_187227_b(DATA_CREEPY, (Object)true);
            if (!modifiableattributeinstance.func_180374_a(SPEED_MODIFIER_ATTACKING)) {
                modifiableattributeinstance.func_233767_b_(SPEED_MODIFIER_ATTACKING);
            }
        }
        super.func_70624_b(p_70624_1_);
    }

    protected boolean func_225511_J_() {
        return true;
    }
}

